/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.AdvancementData;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.NewTickingData;
import noobanidus.mods.lootr.common.api.data.TickingData;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import noobanidus.mods.lootr.common.command.IOUtil;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinDimensionDataStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DataStorage {
    @Deprecated
    public static final String ADVANCEMENTS_ID = "lootr/Lootr-AdvancementData";
    @Deprecated
    public static final String DECAYS_ID = "lootr/Lootr-DecayData";
    @Deprecated
    public static final String REFRESHES_ID = "lootr/Lootr-RefreshData";
    public static final class_10741<TickingData> DECAYS = new class_10741("lootr/Lootr-DecayData", TickingData::new, TickingData.CODEC, null);
    public static final class_10741<TickingData> REFRESHES = new class_10741("lootr/Lootr-RefreshData", TickingData::new, TickingData.CODEC, null);
    public static final class_10741<AdvancementData> ADVANCEMENTS = new class_10741("lootr/Lootr-AdvancementData", AdvancementData::new, AdvancementData.CODEC, null);

    @ApiStatus.Internal
    @Nullable
    public static class_26 getDataStorage() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.method_17983();
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(ILootrInfoProvider provider, class_3222 player) {
        return DataStorage.isAwarded(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isAwarded(UUID uuid, class_3222 player) {
        return false;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(ILootrInfoProvider provider, class_3222 player) {
        DataStorage.award(provider.getInfoUUID(), player);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void award(UUID id, class_3222 player) {
    }

    @ApiStatus.Internal
    public static int getDecayValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the decay value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        MinecraftServer server = LootrAPI.getServer();
        TickingData oldData = (TickingData)manager.method_17924(DECAYS);
        NewTickingData data = NewTickingData.getDecayData();
        data.migrateOldData(server, oldData);
        return (int)data.howLongUntilComplete(server, provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isDecayed(ILootrInfoProvider provider) {
        return DataStorage.getDecayValue(provider) == 0;
    }

    @ApiStatus.Internal
    public static void setDecaying(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the decay value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData oldData = (TickingData)manager.method_17924(DECAYS);
        NewTickingData data = NewTickingData.getDecayData();
        MinecraftServer server = LootrAPI.getServer();
        data.migrateOldData(server, oldData);
        data.setCompletesIn(server, provider.getInfoUUID(), LootrAPI.getDecayValue());
    }

    @ApiStatus.Internal
    public static void removeDecayed(ILootrInfoProvider provider) {
    }

    @Deprecated
    @ApiStatus.Internal
    public static void doTick() {
    }

    @ApiStatus.Internal
    public static int getRefreshValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return -1;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the refresh value for {}.", (Object)provider.getInfoUUID());
            return -1;
        }
        TickingData oldData = (TickingData)manager.method_17924(REFRESHES);
        NewTickingData data = NewTickingData.getRefreshData();
        MinecraftServer server = LootrAPI.getServer();
        data.migrateOldData(server, oldData);
        int result = (int)data.howLongUntilComplete(server, provider.getInfoUUID());
        return result;
    }

    @ApiStatus.Internal
    public static boolean isRefreshed(ILootrInfoProvider provider) {
        return DataStorage.getRefreshValue(provider) == 0;
    }

    @ApiStatus.Internal
    public static void setRefreshing(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the refresh value for {}.", (Object)provider.getInfoUUID());
            return;
        }
        TickingData data = (TickingData)manager.method_17924(REFRESHES);
        NewTickingData newData = NewTickingData.getRefreshData();
        MinecraftServer server = LootrAPI.getServer();
        newData.migrateOldData(server, data);
        newData.setCompletesIn(server, provider.getInfoUUID(), LootrAPI.getRefreshValue());
    }

    @ApiStatus.Internal
    public static void removeRefreshed(ILootrInfoProvider provider) {
    }

    @ApiStatus.Internal
    public static LootrSavedData getData(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            if (provider.getInfoLevel() == null || provider.getInfoLevel() != null && provider.getInfoLevel().method_8608()) {
                return null;
            }
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch data for {} at {} with ID {} and cannot continue.", provider.getInfoDimension(), (Object)provider.getInfoPos(), (Object)provider.getInfoUUID());
            return null;
        }
        LootrSavedData result = (LootrSavedData)manager.method_17924(new class_10741(provider.getInfoKey(), LootrSavedData.fromInfo(provider), LootrSavedData.CODEC, null));
        result.update(provider);
        return result;
    }

    @Nullable
    public static ILootrInventory getInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        LootrSavedData data = DataStorage.getData(provider);
        if (data == null) {
            return null;
        }
        return data.getOrCreateInventory(provider, player, filler);
    }

    @ApiStatus.Internal
    public static boolean clearInventories(class_1657 player) {
        return DataStorage.clearInventories(player.method_5667());
    }

    public static Set<String> getAllLootrFiles() {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return Collections.emptySet();
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return Collections.emptySet();
        }
        Path dataPath = server.method_27050(new class_5218("data")).resolve("lootr");
        HashSet<String> files = new HashSet<String>();
        for (String cache : ((AccessorMixinDimensionDataStorage)data).getCache().keySet()) {
            if (!cache.startsWith("lootr/") || cache.startsWith("lootr/Lootr-") || cache.startsWith("lootr/lootr-")) continue;
            files.add(cache);
        }
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String fileName = path.getFileName().toString();
                    if (fileName.startsWith("lootr-") || fileName.startsWith("Lootr-")) {
                        return;
                    }
                    files.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return files;
        }
        return files;
    }

    @ApiStatus.Internal
    public static boolean clearInventories(UUID id) {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return false;
        }
        Set<String> files = DataStorage.getAllLootrFiles();
        int count = 0;
        for (String file : files) {
            class_18 datum = data.method_20786(new class_10741(file, () -> LootrDummyData.INSTANCE, LootrSavedData.CODEC, null));
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for {}, removing from cache.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for {} is not a LootrSavedData instance.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.hasBeenOpened() || !lootrSavedData.clearInventories(id)) continue;
            ++count;
            class_3218 level = server.method_3847(lootrSavedData.getInfoDimension());
            if (level == null) continue;
            class_3215 chunkCache = level.method_14178();
            class_1923 chunkPos = new class_1923(lootrSavedData.getInfoPos());
            if (!chunkCache.method_12123(chunkPos.field_9181, chunkPos.field_9180) || !LoadedChunks.getLoadedChunks((class_5321<class_1937>)lootrSavedData.getInfoDimension()).contains(chunkPos)) continue;
            ILootrInfoProvider provider = null;
            if (lootrSavedData.isEntity()) {
                entity = level.method_66347(lootrSavedData.getInfoUUID());
                if (entity instanceof ILootrEntity) {
                    ILootrEntity cart = (ILootrEntity)entity;
                    provider = cart;
                }
            } else {
                entity = level.method_8321(lootrSavedData.getInfoPos());
                ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(entity);
                if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                    ILootrBlockEntity blockEntity = iLootrBlockEntity;
                    provider = blockEntity;
                }
            }
            if (provider == null) continue;
            provider.removeVisualOpener(id);
            provider.performClose();
            provider.performUpdate();
        }
        if (count > 0) {
            data.method_61873();
            LootrAPI.LOG.info("Cleared {} inventories for player UUID {}", (Object)count, (Object)id.toString());
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static int cullInventories() {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return 0;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return 0;
        }
        Set<String> files = DataStorage.getAllLootrFiles();
        HashSet<String> filesToDelete = new HashSet<String>();
        for (String file : files) {
            class_18 datum = data.method_20786(new class_10741(file, () -> LootrDummyData.INSTANCE, LootrSavedData.CODEC, null));
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for {}, removing from cache.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for {} is not a LootrSavedData instance.", (Object)file);
                ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.canBeCulled()) continue;
            filesToDelete.add(file);
            ((AccessorMixinDimensionDataStorage)data).getCache().remove(file);
        }
        if (!filesToDelete.isEmpty()) {
            IOUtil.cullSavedDataAsync(server, filesToDelete);
            LootrAPI.LOG.info("Culling {} inventories.", (Object)filesToDelete.size());
        }
        return filesToDelete.size();
    }

    private static class LootrDummyData
    extends class_18 {
        public static final LootrDummyData INSTANCE = new LootrDummyData();
    }
}

